/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.itemfilters.item;

import dev.latvian.mods.itemfilters.api.FilterInfo;
import dev.latvian.mods.itemfilters.api.IItemFilter;
import dev.latvian.mods.itemfilters.api.ItemFiltersAPI;
import dev.latvian.mods.itemfilters.core.ItemFiltersStack;
import dev.latvian.mods.itemfilters.gui.InventoryFilterMenu;
import dev.latvian.mods.itemfilters.item.BaseFilterItem;
import dev.latvian.mods.itemfilters.item.ItemInventory;
import java.util.List;
import me.shedaniel.architectury.registry.MenuRegistry;
import me.shedaniel.architectury.registry.menu.ExtendedMenuProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class InventoryFilterItem
extends BaseFilterItem {
    public static ItemInventory getInventory(ItemStack stack) {
        return ((ItemFiltersStack)stack).getInventoryFilterData();
    }

    public int getInventorySize(ItemStack filter) {
        return 27;
    }

    public void addSlots(ItemStack filter, List<FilterSlot> list) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                list.add(new FilterSlot(8 + j * 18, 16 + i * 18));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, final Hand hand) {
        final ItemStack stack = player.func_184586_b(hand);
        if (!world.func_201670_d()) {
            MenuRegistry.openExtendedMenu((ServerPlayerEntity)((ServerPlayerEntity)player), (ExtendedMenuProvider)new ExtendedMenuProvider(){

                public void saveExtraData(PacketBuffer buf) {
                    buf.writeBoolean(hand == Hand.MAIN_HAND);
                }

                public ITextComponent func_145748_c_() {
                    return stack.func_151000_E();
                }

                public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
                    return new InventoryFilterMenu(i, inventory, hand);
                }
            });
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @Override
    public void clearFilterCache(ItemStack filter) {
        super.clearFilterCache(filter);
        ItemInventory inventory = InventoryFilterItem.getInventory(filter);
        for (ItemStack item : inventory.getItems()) {
            IItemFilter f = ItemFiltersAPI.getFilter(item);
            if (f == null) continue;
            f.clearFilterCache(item);
        }
    }

    @Override
    public void resetFilterData(ItemStack filter) {
        ItemInventory inventory = InventoryFilterItem.getInventory(filter);
        inventory.func_174888_l();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addInfo(ItemStack filter, FilterInfo info, boolean expanded) {
        ItemInventory inventory = InventoryFilterItem.getInventory(filter);
        if (inventory == null) {
            return;
        }
        for (ItemStack stack1 : inventory.getItems()) {
            IItemFilter filter1;
            info.add(stack1.func_200301_q());
            if (!expanded || (filter1 = ItemFiltersAPI.getFilter(stack1)) == null) continue;
            info.push();
            filter1.addInfo(stack1, info, true);
            info.pop();
        }
    }

    public static class FilterSlot {
        public final int x;
        public final int y;

        public FilterSlot(int _x, int _y) {
            this.x = _x;
            this.y = _y;
        }
    }
}

